<?php
$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

$containerClass = '';
if($option['header_container_width']!=''){
    $containerClass = $option['header_container_width'];
}

if($option['header_topbar_show']==true){ ?>
<div class="above_header">
    <div class="<?php echo esc_attr( $containerClass ); ?>">
        <div class="row align-items-center">
            <div class="col-lg-6 col-md-6 col-12">
                <div class="header_left">
                    <ul class="header_contact">
                        <?php if( !empty($option['header_phone']) ){ ?>
                        <li><a href="<?php echo esc_attr( 'tel:' . $option['header_phone'] ); ?>"><i class="fa fa-phone"></i> <?php echo esc_html( $option['header_phone'] ); ?></a></li>
                        <?php } ?>

                        <?php if( !empty($option['header_email']) ){ ?>
                        <li><a href="<?php echo esc_attr( 'mailto:' . sanitize_email( $option['header_email'] ) ); ?>"><i class="fa fa-envelope"></i> <?php echo esc_html( $option['header_email'] ); ?></a></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-12">
                <div class="header_right">
                    <ul class="header_social_icons">
                        <?php if( $option['facebook_link'] != '' ){ ?>
                        <li><a href="<?php echo esc_url( $option['facebook_link'] ); ?>"><i class="fa fa-facebook"></i></a></li>
                        <?php } ?>

                        <?php if( $option['twitter_link'] != '' ){ ?>
                        <li><a href="<?php echo esc_url( $option['twitter_link'] ); ?>"><i class="fa fa-twitter"></i></a></li>
                        <?php } ?>

                        <?php if( $option['linkedin_link'] != '' ){ ?>
                        <li><a href="<?php echo esc_url( $option['linkedin_link'] ); ?>"><i class="fa fa-linkedin"></i></a></li>
                        <?php } 
                        
                        // Print more social icons here
                        do_action('jewelery_store_header_social_icons');
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<?php } ?>