<?php
$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

$text_align_class = '';
if($option['subheader_text_align']!=''){
    $text_align_class = $option['subheader_text_align'];
}

$containerClass = '';
if($option['subheader_container_width']!=''){
    $containerClass = $option['subheader_container_width'];
}

$bg = '';
$class = '';
if($option['subheader_bg_image']){
	$bg = 'background-image:url('.esc_url( $option['subheader_bg_image'] ).');';
	$class = ' has_section_bg_image';
}

$text_align_class = trim($text_align_class);
$class = trim($class);

if( $option['subheader_show'] == true ){
?>
<div class="page_header">
	<div class="page_header_above <?php echo esc_attr( $class ); ?>" style="<?php echo esc_attr( $bg ); ?>">
		<div class="<?php echo esc_attr( $containerClass ); ?>">
			<div class="row">
				<div class="col-12 text-<?php echo esc_attr( $text_align_class ); ?>">
					<h1 class="page_header_title">
	            	<?php 
						if ( is_day() ) : 
						
							printf( __( 'Daily Archives: %s', 'jewelry-store' ), get_the_date() );
						
						elseif ( is_month() ) :
						
							printf( __( 'Monthly Archives: %s', 'jewelry-store' ), (get_the_date( 'F Y' ) ));
							
						elseif ( is_year() ) :
						
							printf( __( 'Yearly Archives: %s', 'jewelry-store' ), (get_the_date( 'Y' ) ) );
							
						elseif ( is_category() ) :
						
							printf( __( 'Category Archives: %s', 'jewelry-store' ), (single_cat_title( '', false ) ));

						elseif ( is_tag() ) :
						
							printf( __( 'Tag Archives: %s', 'jewelry-store' ), (single_tag_title( '', false ) ));
							
						elseif ( is_404() ) :

							printf( __( 'Error 404', 'jewelry-store' ));
							
						elseif ( is_author() ) :
						
							printf( __( 'Author: %s', 'jewelry-store' ), (get_the_author( '', false ) ));

						elseif ( is_archive() ):		
							
							printf( __( '%s', 'jewelry-store' ), (get_the_archive_title( '', false ) ));

						else :
								the_title();
						endif;
					?>
					</h1>
				</div>
			</div>
		</div>
	</div>
	<div class="page_header_below">
		<div class="<?php echo esc_attr( $containerClass ); ?>">
	    	<div class="row">
	        	<div class="col-12">
					<div class="breadcrumbs_container">
						<ul class="breadcrumbs">
		                    <?php 
		                    if ( function_exists('jewelry_store_breadcrumbs') ) {
		                    	jewelry_store_breadcrumbs();
		                	}
		                    ?>
		                </ul>
					</div>
	        	</div>
	    	</div>
		</div>
	</div>
</div>
<?php } ?>