<?php 
$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

$containerClass = '';
if($option['blog_container_width']!=''){
    $containerClass = $option['blog_container_width'];
}

$columnLayoutClass = '';
if($option['blog_column']==4){
    $columnLayoutClass = 'col-lg-3 col-md-6 col-12';
}else if($option['blog_column']==3){
    $columnLayoutClass = 'col-lg-4 col-md-6 col-12';
}else{
    $columnLayoutClass = 'col-lg-6 col-md-6 col-12';
}

if($option['blog_enable']==true){
?>
<div id="blog" class="section blog_section">
    <div class="">
        <div class="<?php echo esc_attr( $containerClass ); ?>">
            <?php if( $option['blog_subtitle'] != '' || $option['blog_title'] != '' || $option['blog_desc'] != '' ){ ?>
            <div class="row">
                <div class="col-12">
                    <div class="header_section wow animated fadeInUp">
                        <div class="header_section_container">
                            <div class="header_section_details">
                                <?php if( $option['blog_subtitle'] != '' || $option['blog_title'] != '' ){ ?>
                                    <h2 class="section_title_wrap">
                                        <?php if( $option['blog_subtitle'] != '' ){ ?>
                                        <span class="section_subtitle"><?php echo wp_kses_post($option['blog_subtitle']); ?></span>
                                        <?php } ?>
                                        <?php if( $option['blog_title'] != '' ){ ?>
                                        <span class="section_title"><?php echo wp_kses_post($option['blog_title']); ?></span>
                                        <?php } ?>
                                    </h2>
                                <?php } ?>
                                <?php if($option['blog_desc']!=''){ ?>
                                    <p class="section_desc"><?php echo wp_kses_post($option['blog_desc']); ?></p>
                                <?php } ?>
                            </div>                          
                        </div>
                    </div>
                </div>                  
            </div>
            <?php } ?>
            <div class="row">
                <?php                
                $args = array(
                    'posts_per_page' => $option['blog_to_show'],
                    'suppress_filters' => 0,
                );

                if ( $option['blog_cat'] > 0 ) {
                    $args['category__in'] = array( $option['blog_cat'] );
                }
                            
                if ( $option['blog_orderby'] && $option['blog_orderby'] != 'default' ) {
                    $args['orderby'] = $option['blog_orderby'];
                }

                if ( $option['blog_order']) {
                    $args['order'] = $option['blog_order'];
                }

                $query = new WP_Query( $args );
                if ( $query->have_posts() ) :
                
                /* Start the Loop */
                while ( $query->have_posts() ) : $query->the_post(); 
                ?>
                <div class="<?php echo esc_attr( $columnLayoutClass ); ?> wow animated fadeInUp">
                    <div class="news">
                        <div class="news_container">
                            <?php if( has_post_thumbnail() ): ?>
                            <div class="news_image">
                                <a href="<?php the_permalink(); ?>">
                                    <?php 
                                    the_post_thumbnail('large');
                                    ?>
                                </a>
                                <div class="news_overlay">
                                    <a class="news_icon" href="<?php the_permalink(); ?>"><i class="fa fa-share"></i></a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <div class="news_content">                                
                                <h3 class="news_title">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_title(); ?>
                                    </a>
                                </h3>
                                <div class="news_meta">
                                    <span class="news_author">
                                        <?php 
                                        _e('By: ','jewelry-store');

                                        echo get_the_author_link();
                                        ?>  
                                    </span>
                                    <span class="news_date">
                                        <?php the_date( get_option('date_format') ); ?>  
                                    </span>
                                </div>
                                <div class="news_desc">
                                    <?php
                                        the_excerpt();
                                    ?>                                    
                                </div>                                
                            </div>
                        </div>
                    </div>                      
                </div>
                <?php endwhile; wp_reset_postdata();
                else : 
                    get_template_part( 'template-parts/content', 'none' ); 
                endif; 
                ?>                
            </div>
        </div>
    </div>
</div>
<?php } ?>