<?php
if ( ! function_exists( 'jewelry_store_get_media_url' ) ) {
    function jewelry_store_get_media_url($media = array(), $size = 'full' )
    {
        $media = wp_parse_args( $media, array('url' => '', 'id' => ''));
        $url = '';
        if ($media['id'] != '') {
            if ( strpos( get_post_mime_type( $media['id'] ), 'image' ) !== false ) {
                $image = wp_get_attachment_image_src( $media['id'],  $size );
                if ( $image ){
                    $url = $image[0];
                }
            } else {
                $url = wp_get_attachment_url( $media['id'] );
            }
        }

        if ($url == '' && $media['url'] != '') {
            $id = attachment_url_to_postid( $media['url'] );
            if ( $id ) {
                if ( strpos( get_post_mime_type( $id ), 'image' ) !== false ) {
                    $image = wp_get_attachment_image_src( $id,  $size );
                    if ( $image ){
                        $url = $image[0];
                    }
                } else {
                    $url = wp_get_attachment_url( $id );
                }
            } else {
                $url = $media['url'];
            }
        }
        return $url;
    }
}


if ( ! function_exists( 'jewelry_store_custom_excerpt_length' ) ) :

    /**
     * Custom excerpt length
     */
    function jewelry_store_custom_excerpt_length( $length ) {
    	
    	if( is_admin() ){
    		return $length;
    	}

    	return 20;

    }

    add_filter( 'excerpt_length', 'jewelry_store_custom_excerpt_length', 999 );

endif;


if ( ! function_exists( 'jewelry_store_new_excerpt_more' ) ) :
    /**
     * Remove […]
     */
    function jewelry_store_new_excerpt_more( $more ) {
    	
    	$excerpt_readmore = sprintf(__('Read More','jewelry-store'));

        // If empty, return
        if ( '' == $excerpt_readmore ) {
            return $more;
        }

        return apply_filters( 'jewelry_store_excerpt_more_output', sprintf( ' ... <a title="%1$s" class="more-link" href="%2$s">%3$s <i class="fa fa-angle-double-right"></i></a>',
            the_title_attribute( 'echo=0' ),
            esc_url( get_permalink( get_the_ID() ) ),
            wp_kses_post( $excerpt_readmore )
        ) );
    }
    add_filter('excerpt_more', 'jewelry_store_new_excerpt_more');

endif;

// Content Read More
if ( ! function_exists( 'jewelry_store_blog_content_more' ) ) {

    function jewelry_store_blog_content_more( $more ) {

        $excerpt_readmore = sprintf(__('Read More','jewelry-store'));

        // If empty, return
        if ( '' == $excerpt_readmore ) {
            return $more;
        }

        return apply_filters( 'jewelry_store_content_more_link_output', sprintf( '<p class="more-link-container"><a title="%1$s" class="more-link content-more-link" href="%2$s">%3$s%4$s <i class="fa fa-angle-double-right"></i></a></p>',
            the_title_attribute( 'echo=0' ),
            esc_url( get_permalink( get_the_ID() ) . apply_filters( 'jewelry_store_more_jump','#more-' . get_the_ID() ) ),
            wp_kses_post( $excerpt_readmore ),
            '<span class="screen-reader-text">' . get_the_title() . '</span>'
        ) );

    }
    add_filter( 'the_content_more_link', 'jewelry_store_blog_content_more', 15 );
}

function jewelry_store_blog_read_more_button( $output ) {

    $archive_readmore_button = true;
    $excerpt_readmore = sprintf(__('Read More','jewelry-store'));

    $class='';
    if($archive_readmore_button){
        $class = 'button';
    }

    if ( !$archive_readmore_button ) {
        return $output;
    }

    return sprintf( '%5$s<p class="more-link-container"><a title="%1$s" class="more-link %6$s" href="%2$s">%3$s%4$s <i class="fa fa-angle-double-right"></i></a></p>',
        the_title_attribute( 'echo=0' ),
        esc_url( get_permalink( get_the_ID() ) . apply_filters( 'jewelry_store_more_jump','#more-' . get_the_ID() ) ),
        wp_kses_post( $excerpt_readmore ),
        '<span class="screen-reader-text">' . get_the_title() . '</span>',
        'jewelry_store_excerpt_more_output' == current_filter() ? ' ... ' : '',
        esc_attr($class)
    );

}
add_filter( 'jewelry_store_excerpt_more_output', 'jewelry_store_blog_read_more_button' );
add_filter( 'jewelry_store_content_more_link_output', 'jewelry_store_blog_read_more_button' );

if ( ! function_exists( 'jewelry_store_excerpt' ) ) {
    function jewelry_store_excerpt( $length = 7 ) {
        global $post;

        return implode(' ', array_slice(explode(' ', get_the_excerpt()), 0, $length))."...\n";
    }
}

// hooks for woocommerce cart value

function jewelry_store_woocommerce_navigation_add_to_cart_fragment( $fragments ) {
           global $woocommerce;
   
           $cart_value = sprintf ( __( '<span class="cart-value">%d</span>', 'jewelry-store'), WC()->cart->get_cart_contents_count() );
           $cart_inner_tag = sprintf('<a class="cart-total" href="%1$s" title="%2$s"><i class="fa fa-shopping-cart"></i>%3$s</a>',
                           esc_url( wc_get_cart_url() ),
                           esc_attr('View cart', 'jewelry-store'),
                          $cart_value
                  );
  
          ob_start();
          echo $cart_inner_tag;
          $fragments['.cart-total'] = ob_get_clean();

          return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'jewelry_store_woocommerce_navigation_add_to_cart_fragment' ); 


function jewelry_store_woocommerce_mini_cart_fragment( $fragments ) {
    global $woocommerce;

    ob_start();
    ?>
    <div class="shopping_cart">
      <?php woocommerce_mini_cart(); ?>
    </div>
    <?php
    $fragments['.shopping_cart'] = ob_get_clean();
    return $fragments;
} 
add_filter( 'woocommerce_add_to_cart_fragments', 'jewelry_store_woocommerce_mini_cart_fragment' );

// Yith WCWL

if ( defined( 'YITH_WCWL' ) && ! function_exists( 'jewelry_store_yith_wcwl_get_items_count' ) ) {
 function jewelry_store_yith_wcwl_get_items_count() {
  ob_start();
  ?>
  <span class="favorite-value">
    <?php echo esc_html( yith_wcwl_count_all_products() ); ?>
  </span>
  <?php
  return ob_get_clean();
 }
 // add_shortcode( 'yith_wcwl_items_count', 'jewelry_store_yith_wcwl_get_items_count' );
}

if ( defined( 'YITH_WCWL' ) && ! function_exists( 'jewelry_store_yith_wcwl_ajax_update_count' ) ) {
 function jewelry_store_yith_wcwl_ajax_update_count() {
  wp_send_json( array(
      'count' => yith_wcwl_count_all_products()
  ) );
 }
 add_action( 'wp_ajax_yith_wcwl_update_wishlist_count', 'jewelry_store_yith_wcwl_ajax_update_count' );
 add_action( 'wp_ajax_nopriv_yith_wcwl_update_wishlist_count', 'jewelry_store_yith_wcwl_ajax_update_count' );
}

if ( defined( 'YITH_WCWL' ) && ! function_exists( 'jewelry_store_yith_wcwl_enqueue_custom_script' ) ) {
 function jewelry_store_yith_wcwl_enqueue_custom_script() {
  wp_add_inline_script(
      'jquery-yith-wcwl',
      "
        jQuery( function( $ ) {
          $( document ).on( 'added_to_wishlist removed_from_wishlist', function() {
            $.get( yith_wcwl_l10n.ajax_url, {
              action: 'yith_wcwl_update_wishlist_count'
            }, function( data ) {
              $('.favorite-value').html( data.count );
            } );
          } );
        } );

      "
  );
 }
 add_action( 'wp_enqueue_scripts', 'jewelry_store_yith_wcwl_enqueue_custom_script', 20 );
}

// End Yith WCWL

// YITH Compare button

function jewelry_store_yith_woocompare_button( $button_text ){
    return '<i class="fa fa-exchange"></i>';
}
add_filter('wpml_translate_single_string','jewelry_store_yith_woocompare_button');

function jewelry_store_yith_woocompare_add_count(){
    global $yith_woocompare;
    echo count($yith_woocompare->obj->products_list) + 1;
    die();
}
add_filter('wc_ajax_yith_woocompare_add_count','jewelry_store_yith_woocompare_add_count' );
add_filter('wc_ajax_nopriv_yith_woocompare_add_count','jewelry_store_yith_woocompare_add_count' );

function jewelry_store_yith_woocompare_update_count(){
    global $yith_woocompare;
    echo count($yith_woocompare->obj->products_list) - 1;
    die();
}
add_filter('wc_ajax_yith_woocompare_update_count','jewelry_store_yith_woocompare_update_count' );
add_filter('wc_ajax_nopriv_yith_woocompare_update_count','jewelry_store_yith_woocompare_update_count' );

// End YITH Compare button

// Get Started Notice

add_action( 'wp_ajax_jewelry_store_dismissed_notice_handler', 'jewelry_store_ajax_notice_handler' );
function jewelry_store_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function jewelry_store_deprecated_hook_admin_notice() {
        if ( ! get_option('dismissed-get_started', FALSE ) ) {
            ?>
            <div class="updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="jewelry-store-getting-started-notice clearfix">
                    <div class="jewelry-store-theme-screenshot">
                        <img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/screenshot.png" class="screenshot" alt="<?php esc_attr_e( 'Theme Screenshot', 'jewelry-store' ); ?>" />
                    </div>
                    <div class="jewelry-store-theme-notice-content">
                        <h2 class="jewelry-store-notice-h2">
                            <?php
                        printf(
                            /* translators: 1: welcome page link starting html tag, 2: welcome page link ending html tag. */
                            esc_html__( 'Welcome! Thank you for choosing %1$s!', 'jewelry-store' ), '<strong>'. wp_get_theme()->get('Name'). '</strong>' );
                        ?>
                        </h2>

                        <p class="plugin-install-notice"><?php echo sprintf(__('Install and activate <strong>Britetechs Companion</strong> plugin for taking full advantage of all the features this theme has to offer.', 'jewelry-store')) ?></p>

                        <a class="jewelry-store-btn-get-started button button-primary button-hero jewelry-store-button-padding" href="#" data-name="" data-slug=""><?php esc_html_e( 'Get started with jewelry store', 'jewelry-store' ) ?></a><span class="jewelry-store-push-down">
                        <?php
                            /* translators: %1$s: Anchor link start %2$s: Anchor link end */
                            printf(
                                'or %1$sCustomize theme%2$s</a></span>',
                                '<a target="_blank" href="' . esc_url( admin_url( 'customize.php' ) ) . '">',
                                '</a>'
                            );
                        ?>
                    </div>
                </div>
            </div>
        <?php }
}
add_action( 'admin_notices', 'jewelry_store_deprecated_hook_admin_notice' );

// Plugin Installer

function jewelry_store_admin_install_plugin() {

    include_once ABSPATH . '/wp-admin/includes/file.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/plugin-install.php';

    if ( ! file_exists( WP_PLUGIN_DIR . '/britetechs-companion' ) ) {
        $api = plugins_api( 'plugin_information', array(
            'slug'   => sanitize_key( wp_unslash( 'britetechs-companion' ) ),
            'fields' => array(
                'sections' => false,
            ),
        ) );

        $skin     = new WP_Ajax_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader( $skin );
        $result   = $upgrader->install( $api->download_link );
    }

    // Activate plugin.
    if ( current_user_can( 'activate_plugin' ) ) {
        $result = activate_plugin( 'britetechs-companion/britetechs-companion.php' );
    }
}
add_action( 'wp_ajax_install_act_plugin', 'jewelry_store_admin_install_plugin' );