<?php

/**
 * Enqueue CSS And JS Files Here
 */
if( !function_exists('jewelry_store_scripts') ){

	function jewelry_store_scripts() {

		$theme = wp_get_theme( 'jewelry-store' );
	    $version = $theme->get( 'Version' );

		$disableGoogleFonts = get_theme_mod('jewelry_store_hide_g_font', 0 );

		if ( $disableGoogleFonts == false ) {
	        wp_enqueue_style('google-fonts', jewelry_store_fonts_url(), array(), $version);
	    }
		
		wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/assets/css/bootstrap.min.css', array(), $version );

		wp_enqueue_style( 'jewelry-store-main', get_template_directory_uri() .'/assets/css/main.css', array(), $version );
		
		wp_enqueue_style( 'owl_carousel', get_template_directory_uri() .'/assets/css/owl.carousel.css', array(), $version );
		
		wp_enqueue_style( 'fontawesome', get_template_directory_uri() .'/assets/css/font-awesome-4.7.0/css/font-awesome.css', array(), $version );
		
		wp_enqueue_style( 'jewelry-store-style', get_template_directory_uri() .'/style.css', array(), $version );

		wp_enqueue_style( 'animate', get_template_directory_uri() .'/assets/css/animate.css', array(), $version );

		wp_enqueue_style( 'jewelry-store-woo', get_template_directory_uri() .'/assets/css/woocommerce.css', array(), $version );

		wp_enqueue_style( 'jewelry-store-editor-style', get_template_directory_uri() .'/assets/css/editor-style.css', array(), $version );

		wp_enqueue_script( 'jquery' );
		
		wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array( 'jquery' ), $version, true );

		wp_enqueue_script( 'bootstrap-smartmenu-js', get_template_directory_uri() . '/assets/js/jquery.smartmenus.js', array(), $version, true );

		wp_enqueue_script( 'wow', get_template_directory_uri() . '/assets/js/wow.js', array(), $version, true );
		
		wp_enqueue_script( 'materialize-js', get_template_directory_uri() . '/assets/js/materialize.js', array(), $version, true );
		
		wp_enqueue_script( 'owl_carousel-js', get_template_directory_uri() . '/assets/js/owl.carousel.js', array(), $version, true );

		wp_enqueue_script( 'jewelry-store', get_template_directory_uri() . '/assets/js/jewelry-store.js', array(), $version, true );
		
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
				wp_enqueue_script( 'comment-reply' );
			}
		
		$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );

		// settings.
	    $jewelry_store_settings = array(
	        'homeUrl'     => home_url( '/' ),
	        'admin_ajax_url'     => admin_url('admin-ajax.php'),
	        'slider_arrow_show' => $option['slider_arrow_show']?$option['slider_arrow_show']:false,
			'slider_pagination_show' => $option['slider_pagination_show']?$option['slider_pagination_show']:false,
			'slider_mouse_drag' => $option['slider_mouse_drag']?$option['slider_mouse_drag']:false,
			'slider_smart_speed' => $option['slider_smart_speed']?$option['slider_smart_speed']:1000,
			'slider_scroll_speed' => $option['slider_scroll_speed']?$option['slider_scroll_speed']:2500,
			'slider_animateIn' => $option['slider_animateIn']?$option['slider_animateIn']:'',
			'slider_animateOut' => $option['slider_animateOut']?$option['slider_animateOut']:'',
			'shop_column' => $option['shop_column']?$option['shop_column']:4,
			'testimonial_column' => $option['testimonial_column']?$option['testimonial_column']:4,
			'team_column' => $option['team_column']?$option['team_column']:4,
			'is_frontpage' => is_front_page(),
			'theme_color' => $option['theme_color'],
	    );
		wp_localize_script( 'bootstrap', 'jewelry_store_settings', $jewelry_store_settings );
	}

	add_action( 'wp_enqueue_scripts', 'jewelry_store_scripts' );

}

// Enqueue Admin Scripts

if( ! function_exists('jewelry_store_admin_enqueue_css_and_js_files') ):

	function jewelry_store_admin_enqueue_css_and_js_files(){

		wp_enqueue_style('jewelry-store-drag-drop', get_template_directory_uri() . '/assets/css/admin.css');

		wp_enqueue_script( 'jewelry-store-admin-script', get_template_directory_uri() . '/assets/js/jewelry-store-admin-script.js', array( 'jquery' ), '', true );

		wp_localize_script( 'jewelry-store-admin-script', 'jewelry_store_ajax_object',
	        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
	    );

	}

	add_action( 'admin_enqueue_scripts', 'jewelry_store_admin_enqueue_css_and_js_files');

endif;