<?php
function jewelry_store_media_range( $css_prop, $obj_value, $default, $media = 'desktop', $ext = '' ) {
    if( is_string( $obj_value ) && is_array( json_decode( $obj_value, true ) ) ){
        /* It means that we have media queries active */
        $json    = json_decode( $obj_value );
        $value   = '';
        if ( $media == 'desktop' && $json->desktop != $default ) {
            if ( is_array( $css_prop ) ) {
                $value   = $css_prop[0] . ': ' . esc_attr ( $json->desktop ) . $ext . ';';
                if ( count( $css_prop ) > 1 ) {
                    $value  .= $css_prop[1] . ': ' . esc_attr ( $json->desktop ) . $ext . ';';
                }
            } else {
                $value   = $css_prop . ': ' . esc_attr ( $json->desktop ) . $ext . ';';
            }
        }

        if ( $media == 'mobile' && $json->mobile != $default ) {
            if ( is_array( $css_prop ) ) {
                $value   = $css_prop[0] . ': ' . esc_attr ( $json->mobile ) . $ext . ';';
                if ( count( $css_prop ) > 1 ) {
                    $value  .= $css_prop[1] . ': ' . esc_attr ( $json->mobile ) . $ext . ';';
                }
            } else {
                $value   = $css_prop . ': ' . esc_attr ( $json->mobile ) . $ext . ';';
            }
        }

        if ( $media == 'tablet' && $json->tablet != $default ) {
            if ( is_array( $css_prop ) ) {
                $value   = $css_prop[0] . ': ' . esc_attr ( $json->tablet ) . $ext . ';';
                if ( count( $css_prop ) > 1 ) {
                    $value  .= $css_prop[1] . ': ' . esc_attr ( $json->tablet ) . $ext . ';';
                }
            } else {
                $value   = $css_prop . ': ' . esc_attr ( $json->tablet ) . $ext . ';';
            }
        }

        return $value;
    }

    return false;
}

function jewelry_store_customizer_value( $control, $css_selector, $css_prop, array $default, $ext = '' ) {
    if ( $control ) {
        // $control        = get_theme_mod( $control );
        $option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );
        $control = $option[$control];
        $return         = '';

        if( is_string( $control ) && is_array( json_decode( $control, true ) ) ){
            $desktop_val    = jewelry_store_media_range( $css_prop, $control,  $default[0], 'desktop', $ext );
            $tablet_val     = jewelry_store_media_range( $css_prop, $control, $default[1], 'tablet', $ext );
            $mobile_val     = jewelry_store_media_range( $css_prop, $control, $default[2], 'mobile', $ext );

            if ( !empty( $desktop_val ) ) {
                $return         = $css_selector . ' { ';
                $return        .= $desktop_val;
                $return        .= '} ';
            }

            if ( !empty( $tablet_val ) ) {
                $return        .= '@media (max-width:991px) {';
                $return        .= $css_selector . ' { ';
                $return        .= $tablet_val;
                $return        .= '} } ';
            }

            if ( !empty( $mobile_val ) ) {
                $return        .= '@media (max-width:768px) {';
                $return        .= $css_selector . ' { ';
                $return        .= $mobile_val;
                $return        .= '} } ';
            }
        } else {
            if ( !empty( $control ) && $control != $default[0] ) {
                $return        .= $css_selector . ' { ';
                $return        .= esc_attr( $control ) . $ext . ';';
                $return        .= ' } ';
            }
        }

        return $return;
    }

    return false;
}

function jewelry_store_generate_dynamic_style(){

	$option = wp_parse_args(  get_option( 'jewelrystore_option', array() ), jewelry_store_reset_data() );
	list($r, $g, $b) = sscanf($option['theme_color'], "#%02x%02x%02x");

	$css_output = '';

	// root
	$css_output .= ':root{
		--bs-primary:'.$option['theme_color'].';
		--bs-primary-rgb:rgb('.$r.','.$g.','.$b.');
        --bs-subheader-bg-color:'.$option['subheader_overlay_color'].';
        --bs-subheader-bg-alpha:'.$option['subheader_overlay_color_opacity'].';
        --bs-subheader-bg-attachment:'.$option['subheader_bg_attachment'].';
        --bs-big-banner-overlay-color:'.$option['slider_overlay_color'].';
        --bs-big-banner-overlay-alpha:'.$option['slider_overlay_color_opacity'].';
	}';

    // Logo
    $css_output .= jewelry_store_customizer_value( 'logo_width', '.header_logo a:has(img),.site-logo a:has(img),.header_transparent_logo', array( 'max-width' ), array( $option['logo_width'], $option['logo_width'], $option['logo_width'] ), 'px' );

    // Subheader Section
    $css_output .= jewelry_store_customizer_value( 'subheader_height', '.page_header_above', array( 'min-height' ), array( $option['subheader_height'], $option['subheader_height'], $option['subheader_height'] ), 'px' );

	// Body Typography
	$css_output .= jewelry_store_customizer_value( 'body_font_size', 'body', array( 'font-size' ), array( $option['body_font_size'], $option['body_font_size'], $option['body_font_size'] ), 'px' );

    $css_output .= jewelry_store_customizer_value( 'body_line_height', 'body', array( 'line-height' ), array( $option['body_line_height'], $option['body_line_height'], $option['body_line_height'] ) );

    $css_output .= jewelry_store_customizer_value( 'body_letter_spacing', 'body', array( 'letter-spacing' ), array( $option['body_letter_spacing'], $option['body_letter_spacing'], $option['body_letter_spacing'] ), 'px' );

    $css_output .= 'body{
        font-weight: '.esc_attr($option['body_font_weight']).';
        font-style: '.esc_attr($option['body_font_style']).';
        text-transform: '.esc_attr($option['body_text_transform']).';
        text-decoration: '.esc_attr($option['body_text_decoration']).';
    }';

    // Headings Typography

    for( $i = 1; $i <= 6; $i++ ){

        $css_output .= jewelry_store_customizer_value( 'h'.$i.'_font_size', 'h'.$i, array( 'font-size' ), array( $option['h'.$i.'_font_size'], $option['h'.$i.'_font_size'], $option['h'.$i.'_font_size'] ), 'px' );

        $css_output .= jewelry_store_customizer_value( 'h'.$i.'_line_height', 'h'.$i, array( 'line-height' ), array( $option['h'.$i.'_line_height'], $option['h'.$i.'_line_height'], $option['h'.$i.'_line_height'] ) );

        $css_output .= jewelry_store_customizer_value( 'h'.$i.'_letter_spacing', 'h'.$i, array( 'letter-spacing' ), array( $option['h'.$i.'_letter_spacing'], $option['h'.$i.'_letter_spacing'], $option['h'.$i.'_letter_spacing'] ), 'px' );

        $css_output .= 'h'.$i.'{
            font-weight: '.esc_attr($option['h'.$i.'_font_weight']).';
            font-style: '.esc_attr($option['h'.$i.'_font_style']).';
            text-transform: '.esc_attr($option['h'.$i.'_text_transform']).';
            text-decoration: '.esc_attr($option['h'.$i.'_text_decoration']).';
        }';

    }

	wp_add_inline_style('jewelry-store-style',$css_output);
}
add_action( 'wp_enqueue_scripts', 'jewelry_store_generate_dynamic_style' );