<?php
if( ! function_exists('jewelry_store_customizer_header_settings') ){
    function jewelry_store_customizer_header_settings( $wp_customize ){

        $option = jewelry_store_reset_data();

        $wp_customize->add_panel( 'header_section',
            array(
                'title'          => esc_html__( 'Header', 'jewelry-store' ),
                'capability'     => 'edit_theme_options',
                'priority'       => 1,
            )
        );
            // Site identity
            $wp_customize->add_section( 'title_tagline',
                array(
                    'priority'      => 1,
                    'title'         => __('Site Identity','jewelry-store'),
                    'panel'         => 'header_section',
                )
            );

            if ( class_exists( 'Jewelry_Store_Customizer_Range_Control' ) ) {

                $wp_customize->add_setting( 'jewelrystore_option[logo_width]', array(
                    'default'           => $option['logo_width'],
                    'capability'        => 'edit_theme_options',
                    'sanitize_callback' => 'jewelry_store_sanitize_range_value',
                    'type'          => 'option',
                    'priority'      => 1,
                ) );
                $wp_customize->add_control( new Jewelry_Store_Customizer_Range_Control( $wp_customize, 'jewelrystore_option[logo_width]', 
                    array(
                        'label'      => __( 'Logo Width', 'jewelry-store' ),
                        'section'  => 'title_tagline',
                        'media_query'   => true,
                        'input_attr'    => array(
                            'mobile'  => array(
                                'min'           => 50,
                                'max'           => 500,
                                'step'          => 1,
                                'default_value' => $option['logo_width'],
                            ),
                            'tablet'  => array(
                                'min'           => 50,
                                'max'           => 500,
                                'step'          => 1,
                                'default_value' => $option['logo_width'],
                            ),
                            'desktop' => array(
                                'min'           => 50,
                                'max'           => 500,
                                'step'          => 1,
                                'default_value' => $option['logo_width'],
                            ),
                        ),
                    ) ) 
                );

            }

            // Header Above
            $wp_customize->add_section( 'header_above' ,
                array(
                    'priority'    => 1,
                    'title'       => esc_html__( 'Header Above', 'jewelry-store' ),
                    'panel'       => 'header_section',
                )
            );
                // Enable/Disable Header above bar
                $wp_customize->add_setting( 'jewelrystore_option[header_topbar_show]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['header_topbar_show'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 1,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[header_topbar_show]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show above header bar', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

                // Container width
                $wp_customize->add_setting( 'jewelrystore_option[header_container_width]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_radio',
                        'default'           => $option['header_container_width'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 2,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[header_container_width]',
                    array(
                        'type'        => 'radio',
                        'label'       => esc_html__('Container Width', 'jewelry-store'),
                        'section'     => 'header_above',
                        'choices' => array(
                            'container'=> __('Container','jewelry-store'),
                            'container-fluid'=> __('Container Full','jewelry-store')
                            ),
                    )
                );

                // Phone
                $wp_customize->add_setting( 'jewelrystore_option[header_phone]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['header_phone'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 3,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[header_phone]',
                    array(
                        'type'        => 'text',
                        'label'       => esc_html__('Phone', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

                // Email
                $wp_customize->add_setting( 'jewelrystore_option[header_email]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['header_email'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 4,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[header_email]',
                    array(
                        'type'        => 'text',
                        'label'       => esc_html__('Email Address', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

                // Facebook URL
                $wp_customize->add_setting( 'jewelrystore_option[facebook_link]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['facebook_link'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 5,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[facebook_link]',
                    array(
                        'type'        => 'text',
                        'label'       => esc_html__('Facebook Link URL', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

                // Twitter URL
                $wp_customize->add_setting( 'jewelrystore_option[twitter_link]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['twitter_link'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 6,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[twitter_link]',
                    array(
                        'type'        => 'text',
                        'label'       => esc_html__('Twitter Link URL', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

                // LinkedIn URL
                $wp_customize->add_setting( 'jewelrystore_option[linkedin_link]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['linkedin_link'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 7,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[linkedin_link]',
                    array(
                        'type'        => 'text',
                        'label'       => esc_html__('LinkedIn Link URL', 'jewelry-store'),
                        'section'     => 'header_above',
                    )
                );

            $wp_customize->add_section( 'header_navigation' ,
                array(
                    'priority'    => 2,
                    'title'       => esc_html__( 'Header Navigation', 'jewelry-store' ),
                    'panel'       => 'header_section',
                )
            );

                // Container width
                $wp_customize->add_setting( 'jewelrystore_option[navigation_container_width]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_radio',
                        'default'           => $option['navigation_container_width'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 1,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[navigation_container_width]',
                    array(
                        'type'        => 'radio',
                        'label'       => esc_html__('Container Width', 'jewelry-store'),
                        'section'     => 'header_navigation',
                        'choices' => array(
                            'container'=> __('Container','jewelry-store'),
                            'container-fluid'=> __('Container Full','jewelry-store')
                            ),
                    )
                );

                // Transparent Navbar
                $wp_customize->add_setting( 'jewelrystore_option[navigation_transparent]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['navigation_transparent'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 2,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[navigation_transparent]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show Transparent Header', 'jewelry-store'),
                        'section'     => 'header_navigation',
       
                    )
                );

                // Transparent Navbar Logo
                $wp_customize->add_setting( 'jewelrystore_option[navigation_transparent_logo]',
                    array(
                        'sanitize_callback' => 'sanitize_text_field',
                        'default'           => $option['navigation_transparent_logo'],
                        'type' => 'option',
                        'priority'    => 3,
                    )
                );
                $wp_customize->add_control( new wp_Customize_Image_Control( $wp_customize,'jewelrystore_option[navigation_transparent_logo]',
                    array(
                        'label'       => esc_html__('Transparent Header Logo', 'jewelry-store'),
                        'section'     => 'header_navigation',
                    ) )
                );

                // Account Icon Show
                $wp_customize->add_setting( 'jewelrystore_option[navigation_account_icon]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['navigation_account_icon'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 4,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[navigation_account_icon]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show Account Icon', 'jewelry-store'),
                        'section'     => 'header_navigation',
                    )
                );

                // Cart Icon Show
                $wp_customize->add_setting( 'jewelrystore_option[navigation_cart_icon]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['navigation_cart_icon'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 5,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[navigation_cart_icon]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show Cart Icon', 'jewelry-store'),
                        'section'     => 'header_navigation',
                    )
                );

            $wp_customize->add_section( 'header_nav_sticky' ,
                array(
                    'priority'    => 4,
                    'title'       => esc_html__( 'Sticky Header', 'jewelry-store' ),
                    'panel'       => 'header_section',
                )
            );

                // Sticky Navbar header
                $wp_customize->add_setting( 'jewelrystore_option[navigation_sticky]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['navigation_sticky'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                        'priority'    => 1,
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[navigation_sticky]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show sticky header', 'jewelry-store'),
                        'section'     => 'header_nav_sticky',
                    )
                );
    }
}
add_action('customize_register','jewelry_store_customizer_header_settings');