<?php
if( ! function_exists('jewelry_store_customizer_footer_settings') ){
    function jewelry_store_customizer_footer_settings( $wp_customize ){

        $option = jewelry_store_reset_data();

        $wp_customize->add_panel( 'footer_section',
            array(
                'priority'       => 31,
                'capability'     => 'edit_theme_options',
                'theme_supports' => '',
                'title'          => esc_html__( 'Footer', 'jewelry-store' ),
            )
        );

            $wp_customize->add_section( 'footer_background' ,
                array(
                    'priority'    => 1,
                    'title'       => esc_html__( 'Footer Background', 'jewelry-store' ),
                    'panel'       => 'footer_section',
                )
            );

                $wp_customize->add_setting( 'jewelrystore_option[footer_back_image]',
                    array(
                        'sanitize_callback' => 'esc_url_raw',
                        'default'           => $option['footer_back_image'],
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( new WP_Customize_Image_Control(
                    $wp_customize,
                    'jewelrystore_option[footer_back_image]',
                    array(
                        'label'         => esc_html__('Background Image', 'jewelry-store'),
                        'section'       => 'footer_background',
                        'settings'       => 'jewelrystore_option[footer_back_image]',
                    )
                ));

            $wp_customize->add_section( 'footer_widgets' ,
                array(
                    'priority'    => 2,
                    'title'       => esc_html__( 'Footer Widgets', 'jewelry-store' ),
                    'panel'       => 'footer_section',
                )
            );

                // Container width
                $wp_customize->add_setting( 'jewelrystore_option[footerwidget_container_width]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_radio',
                        'default'           => $option['footerwidget_container_width'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[footerwidget_container_width]',
                    array(
                        'type'        => 'radio',
                        'label'       => esc_html__('Container Width', 'jewelry-store'),
                        'section'     => 'footer_widgets',
                        'choices' => array(
                            'container'=> __('Container','jewelry-store'),
                            'container-fluid'=> __('Container Full','jewelry-store')
                            ),
                    )
                );

                // Footer Layout
                $wp_customize->add_setting( 'jewelrystore_option[footer_column_layout]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_select',
                        'default'           => $option['footer_column_layout'],
                        'transport' => 'postMessage',
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[footer_column_layout]',
                    array(
                        'type'        => 'select',
                        'label'       => esc_html__('Layout', 'jewelry-store'),
                        'section'     => 'footer_widgets',
                        'default' => '0',
                        'description' => esc_html__('Number footer columns to display.', 'jewelry-store'),
                        'choices' => array(
                            '4' => 4,
                            '3' => 3,
                            '2' => 2,
                            '1' => 1,
                            '0' => esc_html__('Disable footer widgets', 'jewelry-store'),
                        )
                    )
                );

                for ( $i = 1; $i<=4; $i ++ ) {
                    $df = 12;
                    if ( $i > 1 ) {
                        $_n = 12/$i;
                        $df = array();
                        for ( $j = 0; $j < $i; $j++ ) {
                            $df[ $j ] = $_n;
                        }
                        $df = join( '+', $df );
                    }
                    $wp_customize->add_setting('jewelrystore_option[footer_custom_'.$i.'_columns]',
                        array(
                            'sanitize_callback' => 'sanitize_text_field',
                            'default' => $df,
                            'transport' => 'postMessage',
                            'type' => 'option',
                        )
                    );
                    $wp_customize->add_control('jewelrystore_option[footer_custom_'.$i.'_columns]',
                        array(
                            'label' => $i == 1 ? __('Custom footer 1 column width', 'jewelry-store') : sprintf( __('Custom footer %s columns width', 'jewelry-store'), $i ),
                            'section' => 'footer_widgets',
                            'description' => esc_html__('Enter int numbers and sum of them must smaller or equal 12, separated by "+"', 'jewelry-store'),
                        )
                    );
                }

            $wp_customize->add_section( 'footer_copyright' ,
                array(
                    'priority'    => 3,
                    'title'       => esc_html__( 'Footer Bottom', 'jewelry-store' ),
                    'panel'       => 'footer_section',
                )
            );

                // Container width
                $wp_customize->add_setting( 'jewelrystore_option[footercopyright_container_width]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_radio',
                        'default'           => $option['footercopyright_container_width'],
                        'transport'         => 'postMessage',
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[footercopyright_container_width]',
                    array(
                        'type'        => 'radio',
                        'label'       => esc_html__('Container Width', 'jewelry-store'),
                        'section'     => 'footer_copyright',
                        'choices' => array(
                            'container'=> __('Container','jewelry-store'),
                            'container-fluid'=> __('Container Full','jewelry-store')
                            ),
                    )
                );

                // Copyright Text
                $wp_customize->add_setting( 'jewelrystore_option[footer_copyright_text]',
                    array(
                        'sanitize_callback' => 'wp_kses_post',
                        'default'           => $option['footer_copyright_text'],
                        'transport' => 'postMessage',
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[footer_copyright_text]',
                    array(
                        'type'        => 'textarea',
                        'label'       => esc_html__('Copyright Contents', 'jewelry-store'),
                        'section'     => 'footer_copyright',
                        'description' => sprintf(__('You must use: [copy], [current_year], [site_title] OR [theme_author]','jewelry-store')),
                    )
                );

                // Back To Top Button
                $wp_customize->add_setting( 'jewelrystore_option[back_to_top_show]',
                    array(
                        'sanitize_callback' => 'jewelry_store_sanitize_checkbox',
                        'default'           => $option['back_to_top_show'],
                        'type' => 'option',
                    )
                );
                $wp_customize->add_control( 'jewelrystore_option[back_to_top_show]',
                    array(
                        'type'        => 'checkbox',
                        'label'       => esc_html__('Show back to top button', 'jewelry-store'),
                        'section'     => 'footer_copyright',
                    )
                );
    }
}
add_action('customize_register','jewelry_store_customizer_footer_settings');