<?php

if ( ! class_exists( 'Jewelry_Store_Customizer' ) ) {

    class Jewelry_Store_Customizer {

        /**
         * Instance
         *
         * @access private
         * @var object
         */
        private static $instance;

        /**
         * Initiator
         */
        public static function get_instance() {
            if ( ! isset( self::$instance ) ) {
                self::$instance = new self;
            }
            return self::$instance;
        }

        /**
         * Constructor
         */
        public function __construct() {
            add_action( 'customize_preview_init', array( $this, 'customize_preview_js' ) );
            add_action( 'customize_register', array( $this, 'customizer_register' ) );
            add_action( 'after_setup_theme', array( $this, 'customizer_settings' ) );
            add_action( 'customize_controls_enqueue_scripts', array( $this, 'customize_controls_icons_script' ) );
        }

        function customize_preview_js(){
            wp_enqueue_script( 'jewelry-store-customize-preview', JEWELRY_STORE_PARENT_CUSTOMIZER_URI . '/assets/js/customize-preview.js', array( 'customize-preview' ), '20160816', true );
        }

        function customize_controls_icons_script(){
            $icons = jewelry_store_fontawesome_icons();

            wp_localize_script( 'customize-controls', 'C_Icon_Picker',
                apply_filters( 'c_icon_picker_js_setup',
                    array(
                        'search'    => esc_html__( 'Search', 'jewelry-store' ),
                        'fonts' => array(
                            'font-awesome' => array(
                                'name' => esc_html__( 'Font Awesome', 'jewelry-store' ),
                                'prefix' => 'fa',
                                'url' => esc_url( add_query_arg( array( 'ver'=> '4.7.0' ), get_template_directory_uri() .'/assets/css/font-awesome-4.7.0/css/font-awesome.css' ) ),
                                // Icon class name, separated by |
                                'icons' => implode(' | ', array_values($icons) )
                                ),
                        )
                    )
                )
            );
        }

        function customizer_register( $wp_customize ){

            $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
            $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
            $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
            $wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
            $wp_customize->get_setting('custom_logo')->transport = 'refresh';
            
            require get_parent_theme_file_path('/inc/customizer/sanitization.php');
            require get_parent_theme_file_path('/inc/customizer/customizer-controls.php');
            require get_parent_theme_file_path('/inc/customizer/custom-controls/range-value-control.php');
            $wp_customize->register_control_type( 'Jewelry_Store_Customizer_Range_Control' );
        }

        function customizer_settings(){
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/header.php';
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/general.php';            
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/footer.php';
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/section-blog.php';
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/section-contact.php';
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/customizer-section-manager.php';
            require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR . '/options/typography.php';
        }

    }

}

Jewelry_Store_Customizer::get_instance();