<?php
/**
 * eCommerce Companion Theme Customizer Controls.
 *
 * @package     eCommerce Companion
 * @since       eCommerce Companion 1.0
 */

require JEWELRY_STORE_PARENT_CUSTOMIZER_DIR .'/custom-controls/range-value-control.php';

if ( ! class_exists( 'Jewelry_Store_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0
	 */
	class Jewelry_Store_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			add_action( 'customize_register', array( $this, 'customizer_register' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 *
		 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
		 */
		function customizer_register( $wp_customize ) {
			
			/**
			 * Register controls
			 */
			$wp_customize->register_control_type( 'Jewelry_Store_Customizer_Range_Control' );
		}

	}
}

Jewelry_Store_Customizer::get_instance();