<?php
/**
 * Title: Products
 * Slug: jewelry-blocks/products
 * Categories: jewelry-blocks, products
 */
?>

<?php if (class_exists('WooCommerce')) { ?>
	<!-- wp:group {"className":"product-sec","layout":{"type":"constrained","contentSize":"85%"}} -->
	<div class="wp-block-group product-sec"><!-- wp:spacer {"height":"26px"} -->
	<div style="height:26px" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"textTransform":"uppercase","fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|primary"}}}},"textColor":"primary"} -->
	<h3 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-link-color" style="font-size:14px;font-style:normal;font-weight:700;text-transform:uppercase"><?php esc_html_e('FREE SHIPPING for', 'jewelry-blocks'); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:group {"className":"heading-box","style":{"spacing":{"blockGap":"var:preset|spacing|50","margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group heading-box" style="margin-top:0;margin-bottom:0"><!-- wp:image {"id":142,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/left.png'); ?>" alt="" class="wp-image-142"/></figure>
	<!-- /wp:image -->

	<!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|second-heading"}}},"typography":{"fontStyle":"normal","fontWeight":"400","lineHeight":"0.9","fontSize":"34px"},"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}},"textColor":"second-heading","fontFamily":"marcellus"} -->
	<h2 class="wp-block-heading has-text-align-center has-second-heading-color has-text-color has-link-color has-marcellus-font-family" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;font-size:34px;font-style:normal;font-weight:400;line-height:0.9"><?php esc_html_e('The Bestsellers', 'jewelry-blocks'); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:image {"id":143,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/right.png'); ?>" alt="" class="wp-image-143"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group -->

	<!-- wp:query {"queryId":1,"query":{"perPage":10,"pages":0,"offset":0,"postType":"product","order":"asc","orderBy":"title","author":"","search":"","exclude":[],"sticky":"","inherit":false,"__woocommerceAttributes":[],"__woocommerceStockStatus":["instock","outofstock","onbackorder"],"taxQuery":{"product_cat":[]}},"namespace":"woocommerce/product-query"} -->
	<div class="wp-block-query"><!-- wp:post-template {"className":"products-block-post-template","layout":{"type":"grid","columnCount":4},"__woocommerceNamespace":"woocommerce/product-query/product-template"} -->
	<!-- wp:group {"className":"main-box","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group main-box" style="margin-top:0;margin-bottom:0"><!-- wp:group {"className":"img-box","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group img-box" style="margin-top:0;margin-bottom:0"><!-- wp:woocommerce/product-image {"imageSizing":"thumbnail","isDescendentOfQueryLoop":true,"style":{"border":{"radius":{"topLeft":"20px","topRight":"20px"}}}} /-->

	<!-- wp:woocommerce/product-button {"textAlign":"center","isDescendentOfQueryLoop":true,"fontSize":"small","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} /--></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"text-box-main","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group text-box-main" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--30)"><!-- wp:post-title {"textAlign":"center","level":4,"style":{"spacing":{"margin":{"top":"0","left":"0","right":"0","bottom":"0%"}},"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"}},"__woocommerceNamespace":"woocommerce/product-query/product-title"} /-->

	<!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"center","fontFamily":"montserrat","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"lineHeight":1.4,"fontSize":"15px","fontStyle":"normal","fontWeight":"600"}}} /-->

	<!-- wp:woocommerce/product-rating {"isDescendentOfQueryLoop":true,"textAlign":"center"} /--></div>
	<!-- /wp:group --></div>
	<!-- /wp:group -->
	<!-- /wp:post-template -->

	<!-- wp:query-no-results -->
	<!-- wp:paragraph {"align":"center","placeholder":"Add text or blocks that will display when a query returns no results."} -->
	<p class="has-text-align-center"><?php esc_html_e('No Result Found', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph -->
	<!-- /wp:query-no-results --></div>
	<!-- /wp:query -->

	<!-- wp:spacer {"height":"26px"} -->
	<div style="height:26px" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer --></div>
	<!-- /wp:group -->
<?php } else { ?>
	<!-- wp:group {"className":"product-sec","layout":{"type":"constrained","contentSize":"85%"}} -->
	<div class="wp-block-group product-sec"><!-- wp:spacer {"height":"26px"} -->
	<div style="height:26px" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer -->

	<!-- wp:heading {"textAlign":"center","level":3,"style":{"typography":{"textTransform":"uppercase","fontSize":"14px","fontStyle":"normal","fontWeight":"700"},"elements":{"link":{"color":{"text":"var:preset|color|primary"}}}},"textColor":"primary"} -->
	<h3 class="wp-block-heading has-text-align-center has-primary-color has-text-color has-link-color" style="font-size:14px;font-style:normal;font-weight:700;text-transform:uppercase"><?php esc_html_e('FREE SHIPPING for', 'jewelry-blocks'); ?></h3>
	<!-- /wp:heading -->

	<!-- wp:group {"className":"heading-box","style":{"spacing":{"blockGap":"var:preset|spacing|50","margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group heading-box" style="margin-top:0;margin-bottom:0"><!-- wp:image {"id":142,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/left.png'); ?>" alt="" class="wp-image-142"/></figure>
	<!-- /wp:image -->

	<!-- wp:heading {"textAlign":"center","style":{"elements":{"link":{"color":{"text":"var:preset|color|second-heading"}}},"typography":{"fontStyle":"normal","fontWeight":"400","lineHeight":"0.9","fontSize":"34px"},"spacing":{"margin":{"top":"0","bottom":"0","left":"0","right":"0"}}},"textColor":"second-heading","fontFamily":"marcellus"} -->
	<h2 class="wp-block-heading has-text-align-center has-second-heading-color has-text-color has-link-color has-marcellus-font-family" style="margin-top:0;margin-right:0;margin-bottom:0;margin-left:0;font-size:34px;font-style:normal;font-weight:400;line-height:0.9"><?php esc_html_e('The Bestsellers', 'jewelry-blocks'); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:image {"id":143,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/right.png'); ?>" alt="" class="wp-image-143"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group -->

	<!-- wp:columns {"verticalAlignment":null,"className":"sec-wrap"} -->
	<div class="wp-block-columns sec-wrap"><!-- wp:column {"verticalAlignment":"top"} -->
	<div class="wp-block-column is-vertically-aligned-top"><!-- wp:group {"className":"main-box","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"backgroundColor":"background","layout":{"type":"default"}} -->
	<div class="wp-block-group main-box has-background-background-color has-background" style="border-radius:20px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"img-box","layout":{"type":"default"}} -->
	<div class="wp-block-group img-box"><!-- wp:image {"id":158,"sizeSlug":"full","linkDestination":"none","className":"main-img","style":{"border":{"radius":{"topLeft":"20px","topRight":"20px"}}}} -->
	<figure class="wp-block-image size-full has-custom-border main-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/product1.png'); ?>" alt="" class="wp-image-158" style="border-top-left-radius:20px;border-top-right-radius:20px"/></figure>
	<!-- /wp:image -->

	<!-- wp:group {"className":"sale-box","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group sale-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"13px","textTransform":"capitalize"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
	<p class="has-text-align-center has-white-color has-text-color has-link-color" style="font-size:13px;text-transform:capitalize"><?php esc_html_e('sale', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"cart-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20","margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group cart-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--20)"><!-- wp:image {"id":163,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-163"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"700"}},"textColor":"white"} -->
	<p class="has-white-color has-text-color has-link-color" style="font-size:16px;font-style:normal;font-weight:700"><?php esc_html_e('Add To Cart', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"text-box-main","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":{"bottomLeft":"20px","bottomRight":"20px"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group text-box-main" style="border-bottom-left-radius:20px;border-bottom-right-radius:20px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--30)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
	<h4 class="wp-block-heading has-text-align-center" style="margin-top:0;margin-bottom:0;font-size:14px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Design Hoop Earrings', 'jewelry-blocks'); ?></h4>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"15px","fontStyle":"normal","fontWeight":"600"}},"fontFamily":"montserrat"} -->
	<p class="has-text-align-center has-montserrat-font-family" style="margin-top:0;margin-bottom:0;font-size:15px;font-style:normal;font-weight:600"><?php esc_html_e('$ 19.99 ', 'jewelry-blocks'); ?><span><?php esc_html_e('$ 23.00', 'jewelry-blocks'); ?></span></p>
	<!-- /wp:paragraph -->

	<!-- wp:image {"id":179,"sizeSlug":"full","linkDestination":"none","align":"center","className":"star-img"} -->
	<figure class="wp-block-image aligncenter size-full star-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/star.png'); ?>" alt="" class="wp-image-179"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"verticalAlignment":"top"} -->
	<div class="wp-block-column is-vertically-aligned-top"><!-- wp:group {"className":"main-box","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}},"color":{"background":"#ffffff99"}},"layout":{"type":"default"}} -->
	<div class="wp-block-group main-box has-background" style="border-radius:20px;background-color:#ffffff99;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"img-box","layout":{"type":"default"}} -->
	<div class="wp-block-group img-box"><!-- wp:image {"id":191,"sizeSlug":"full","linkDestination":"none","className":"main-img","style":{"border":{"radius":{"topLeft":"20px","topRight":"20px"}}}} -->
	<figure class="wp-block-image size-full has-custom-border main-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/product2.png'); ?>" alt="" class="wp-image-191" style="border-top-left-radius:20px;border-top-right-radius:20px"/></figure>
	<!-- /wp:image -->

	<!-- wp:group {"className":"cart-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20","margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group cart-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--20)"><!-- wp:image {"id":163,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-163"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"700"}},"textColor":"white"} -->
	<p class="has-white-color has-text-color has-link-color" style="font-size:16px;font-style:normal;font-weight:700"><?php esc_html_e('Add To Cart', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"text-box-main","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":{"bottomLeft":"20px","bottomRight":"20px"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group text-box-main" style="border-bottom-left-radius:20px;border-bottom-right-radius:20px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--30)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
	<h4 class="wp-block-heading has-text-align-center" style="margin-top:0;margin-bottom:0;font-size:14px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Champagne Elegance Silver', 'jewelry-blocks'); ?></h4>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"15px","fontStyle":"normal","fontWeight":"600"}},"fontFamily":"montserrat"} -->
	<p class="has-text-align-center has-montserrat-font-family" style="margin-top:0;margin-bottom:0;font-size:15px;font-style:normal;font-weight:600"><?php esc_html_e('$ 19.99 ', 'jewelry-blocks'); ?><span><?php esc_html_e('$ 23.00', 'jewelry-blocks'); ?></span></p>
	<!-- /wp:paragraph -->

	<!-- wp:image {"id":179,"sizeSlug":"full","linkDestination":"none","align":"center","className":"star-img"} -->
	<figure class="wp-block-image aligncenter size-full star-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/star.png'); ?>" alt="" class="wp-image-179"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"verticalAlignment":"top"} -->
	<div class="wp-block-column is-vertically-aligned-top"><!-- wp:group {"className":"main-box","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"backgroundColor":"background","layout":{"type":"default"}} -->
	<div class="wp-block-group main-box has-background-background-color has-background" style="border-radius:20px;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"img-box","layout":{"type":"default"}} -->
	<div class="wp-block-group img-box"><!-- wp:image {"id":192,"sizeSlug":"full","linkDestination":"none","className":"main-img","style":{"border":{"radius":{"topLeft":"20px","topRight":"20px"}}}} -->
	<figure class="wp-block-image size-full has-custom-border main-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/product3.png'); ?>" alt="" class="wp-image-192" style="border-top-left-radius:20px;border-top-right-radius:20px"/></figure>
	<!-- /wp:image -->

	<!-- wp:group {"className":"sale-box","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"backgroundColor":"primary","layout":{"type":"default"}} -->
	<div class="wp-block-group sale-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"13px","textTransform":"capitalize"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
	<p class="has-text-align-center has-white-color has-text-color has-link-color" style="font-size:13px;text-transform:capitalize"><?php esc_html_e('sale', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"cart-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20","margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group cart-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--20)"><!-- wp:image {"id":163,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-163"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"700"}},"textColor":"white"} -->
	<p class="has-white-color has-text-color has-link-color" style="font-size:16px;font-style:normal;font-weight:700"><?php esc_html_e('Add To Cart', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"text-box-main","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":{"bottomLeft":"20px","bottomRight":"20px"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group text-box-main" style="border-bottom-left-radius:20px;border-bottom-right-radius:20px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--30)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
	<h4 class="wp-block-heading has-text-align-center" style="margin-top:0;margin-bottom:0;font-size:14px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('PANASH Gold-Plated', 'jewelry-blocks'); ?></h4>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"15px","fontStyle":"normal","fontWeight":"600"}},"fontFamily":"montserrat"} -->
	<p class="has-text-align-center has-montserrat-font-family" style="margin-top:0;margin-bottom:0;font-size:15px;font-style:normal;font-weight:600"><?php esc_html_e('$ 19.99 ', 'jewelry-blocks'); ?><span><?php esc_html_e('$ 23.00', 'jewelry-blocks'); ?></span></p>
	<!-- /wp:paragraph -->

	<!-- wp:image {"id":179,"sizeSlug":"full","linkDestination":"none","align":"center","className":"star-img"} -->
	<figure class="wp-block-image aligncenter size-full star-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/star.png'); ?>" alt="" class="wp-image-179"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column -->

	<!-- wp:column {"verticalAlignment":"top"} -->
	<div class="wp-block-column is-vertically-aligned-top"><!-- wp:group {"className":"main-box","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"}},"color":{"background":"#ffffff99"}},"layout":{"type":"default"}} -->
	<div class="wp-block-group main-box has-background" style="border-radius:20px;background-color:#ffffff99;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"img-box","layout":{"type":"default"}} -->
	<div class="wp-block-group img-box"><!-- wp:image {"id":193,"sizeSlug":"full","linkDestination":"none","className":"main-img","style":{"border":{"radius":{"topLeft":"20px","topRight":"20px"}}}} -->
	<figure class="wp-block-image size-full has-custom-border main-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/product4.png'); ?>" alt="" class="wp-image-193" style="border-top-left-radius:20px;border-top-right-radius:20px"/></figure>
	<!-- /wp:image -->

	<!-- wp:group {"className":"cart-box","style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|20","right":"var:preset|spacing|20"},"blockGap":"var:preset|spacing|20","margin":{"top":"0","bottom":"0"}}},"backgroundColor":"primary","layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"center"}} -->
	<div class="wp-block-group cart-box has-primary-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--20)"><!-- wp:image {"id":163,"sizeSlug":"full","linkDestination":"none"} -->
	<figure class="wp-block-image size-full"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/cart.png'); ?>" alt="" class="wp-image-163"/></figure>
	<!-- /wp:image -->

	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}},"typography":{"fontSize":"16px","fontStyle":"normal","fontWeight":"700"}},"textColor":"white"} -->
	<p class="has-white-color has-text-color has-link-color" style="font-size:16px;font-style:normal;font-weight:700"><?php esc_html_e('Add To Cart', 'jewelry-blocks'); ?></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group -->

	<!-- wp:group {"className":"text-box-main","style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":{"bottomLeft":"20px","bottomRight":"20px"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group text-box-main" style="border-bottom-left-radius:20px;border-bottom-right-radius:20px;margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--30)"><!-- wp:heading {"textAlign":"center","level":4,"style":{"typography":{"fontSize":"14px","fontStyle":"normal","fontWeight":"600","textTransform":"uppercase"},"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
	<h4 class="wp-block-heading has-text-align-center" style="margin-top:0;margin-bottom:0;font-size:14px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Purple Contemporary Drop', 'jewelry-blocks'); ?></h4>
	<!-- /wp:heading -->

	<!-- wp:paragraph {"align":"center","style":{"spacing":{"margin":{"top":"0","bottom":"0"}},"typography":{"fontSize":"15px","fontStyle":"normal","fontWeight":"600"}},"fontFamily":"montserrat"} -->
	<p class="has-text-align-center has-montserrat-font-family" style="margin-top:0;margin-bottom:0;font-size:15px;font-style:normal;font-weight:600"><?php esc_html_e('$ 19.99 ', 'jewelry-blocks'); ?><span><?php esc_html_e('$ 23.00', 'jewelry-blocks'); ?></span></p>
	<!-- /wp:paragraph -->

	<!-- wp:image {"id":179,"sizeSlug":"full","linkDestination":"none","align":"center","className":"star-img"} -->
	<figure class="wp-block-image aligncenter size-full star-img"><img src="<?php echo esc_url( get_template_directory_uri() . '/images/star.png'); ?>" alt="" class="wp-image-179"/></figure>
	<!-- /wp:image --></div>
	<!-- /wp:group --></div>
	<!-- /wp:group --></div>
	<!-- /wp:column --></div>
	<!-- /wp:columns -->

	<!-- wp:spacer {"height":"26px"} -->
	<div style="height:26px" aria-hidden="true" class="wp-block-spacer"></div>
	<!-- /wp:spacer --></div>
	<!-- /wp:group -->
<?php } ?>