<?php

add_action( 'admin_menu', 'jewelry_blocks_gettingstarted' );
function jewelry_blocks_gettingstarted() {
	add_theme_page( esc_html__('Begin Installation', 'jewelry-blocks'), esc_html__('Begin Installation', 'jewelry-blocks'), 'edit_theme_options', 'jewelry-blocks-guide-page', 'jewelry_blocks_guide');
}

if ( ! defined( 'JEWELRY_BLOCKS_SUPPORT' ) ) {
define('JEWELRY_BLOCKS_SUPPORT',__('https://wordpress.org/support/theme/jewelry-blocks/','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_REVIEW' ) ) {
define('JEWELRY_BLOCKS_REVIEW',__('https://wordpress.org/support/theme/jewelry-blocks/reviews/','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_LIVE_DEMO' ) ) {
define('JEWELRY_BLOCKS_LIVE_DEMO',__('https://trial.ovationthemes.com/jewelry-blocks/','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_BUY_PRO' ) ) {
define('JEWELRY_BLOCKS_BUY_PRO',__('https://www.ovationthemes.com/products/jeweller-wordpress-theme','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_PRO_DOC' ) ) {
define('JEWELRY_BLOCKS_PRO_DOC',__('https://trial.ovationthemes.com/docs/jewelry-blocks-doc/','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_FREE_DOC' ) ) {
define('JEWELRY_BLOCKS_FREE_DOC',__('https://trial.ovationthemes.com/docs/jewelry-blocks-free-doc/','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_THEME_NAME' ) ) {
define('JEWELRY_BLOCKS_THEME_NAME',__('Premium Jewelry Blocks Theme','jewelry-blocks'));
}
if ( ! defined( 'JEWELRY_BLOCKS_BUNDLE_LINK' ) ) {
define('JEWELRY_BLOCKS_BUNDLE_LINK',__('https://www.ovationthemes.com/products/wordpress-bundle','jewelry-blocks'));
}
/**
 * Theme Info Page
 */
function jewelry_blocks_guide() {

	// Theme info
	$return = add_query_arg( array()) ;
	$theme = wp_get_theme( '' ); ?>

	<div class="getting-started__header">
		<div class="header-box-left">
			<h2><?php echo esc_html( $theme ); ?></h2>
			<p><?php esc_html_e('Version: ', 'jewelry-blocks'); ?><?php echo esc_html($theme['Version']);?></p>
		</div>
		<div class="header-box-right">
			<div class="btn_box">
				<a class="button-primary" href="<?php echo esc_url( JEWELRY_BLOCKS_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'jewelry-blocks'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( JEWELRY_BLOCKS_SUPPORT ); ?>" target="_blank"><?php esc_html_e('Support', 'jewelry-blocks'); ?></a>
				<a class="button-primary" href="<?php echo esc_url( JEWELRY_BLOCKS_REVIEW ); ?>" target="_blank"><?php esc_html_e('Review', 'jewelry-blocks'); ?></a>
			</div>
		</div>
	</div>

	<div class="wrap getting-started">
		<div class="box-container">
			<div class="box-left-main">
				<div class="leftbox">
					<h3><?php esc_html_e('Documentation','jewelry-blocks'); ?></h3>
					<p><?php $theme = wp_get_theme(); 
						echo wp_kses_post( apply_filters( 'description', esc_html( $theme->get( 'Description' ) ) ) );
					?></p>

					<h4><?php esc_html_e('Edit Your Site','jewelry-blocks'); ?></h4>
					<p><?php esc_html_e('Now create your website with easy drag and drop powered by gutenburg.','jewelry-blocks'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( admin_url() . 'site-editor.php' ); ?>" target="_blank"><?php esc_html_e('Edit Your Site','jewelry-blocks'); ?></a>

					<h4><?php esc_html_e('Visit Your Site','jewelry-blocks'); ?></h4>
					<p><?php esc_html_e('To check your website click here','jewelry-blocks'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( home_url() ); ?>" target="_blank"><?php esc_html_e('Visit Your Site','jewelry-blocks'); ?></a>

					<h4><?php esc_html_e('Theme Documentation','jewelry-blocks'); ?></h4>
					<p><?php esc_html_e('Check the theme documentation to easily set up your website.','jewelry-blocks'); ?></p>
					<a class="button-primary" href="<?php echo esc_url( JEWELRY_BLOCKS_FREE_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation','jewelry-blocks'); ?></a>
				</div>
       	</div>
			<div class="box-right-main">
				<h3><?php echo esc_html(JEWELRY_BLOCKS_THEME_NAME); ?></h3>
				<img class="jewelry_blocks_img_responsive" style="width: 100%;" src="<?php echo esc_url( $theme->get_screenshot() ); ?>" />
				<div class="pro-links">
					<div class="pro-links-inner">
						<a class="button-primary livedemo" href="<?php echo esc_url( JEWELRY_BLOCKS_LIVE_DEMO ); ?>" target="_blank"><?php esc_html_e('Live Demo', 'jewelry-blocks'); ?></a>
						<a class="button-primary buynow" href="<?php echo esc_url( JEWELRY_BLOCKS_BUY_PRO ); ?>" target="_blank"><?php esc_html_e('Buy Now', 'jewelry-blocks'); ?></a>
						<a class="button-primary docs" href="<?php echo esc_url( JEWELRY_BLOCKS_PRO_DOC ); ?>" target="_blank"><?php esc_html_e('Documentation', 'jewelry-blocks'); ?></a>
					</div>
						<a class="button-primary bundle-btn" href="<?php echo esc_url( JEWELRY_BLOCKS_BUNDLE_LINK ); ?>" target="_blank"><?php esc_html_e('WordPress Theme Bundle (125+ Themes at Just $99)', 'jewelry-blocks'); ?></a>
				</div>
				<ul style="padding-top:10px">
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Responsive Design', 'jewelry-blocks');?> </li>                 
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Demo Importer', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Section Reordering', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Contact Page Template', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Multiple Blog Layouts', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Unlimited Color Options', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Cross Browser Support', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Detailed Documentation Included', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('WPML Compatible (Translation Ready)', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Woo-commerce Compatible', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Full Support', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('10+ Sections', 'jewelry-blocks');?> </li>
					<li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('SEO Friendly', 'jewelry-blocks');?> </li>
               <li class="upsell-jewelry_blocks"> <div class="dashicons dashicons-yes"></div> <?php esc_html_e('Supper Fast', 'jewelry-blocks');?> </li>
            </ul>
        	</div>
		</div>
	</div>

<?php }?>